"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parse = parse;
exports.create = create;
const node_os_1 = require("node:os");
const node_buffer_1 = require("node:buffer");
// ************************************ //
// *** UTILS FOR PASS.STRINGS FILES *** //
// ************************************ //
/**
 * Parses a string file to convert it to
 * an object
 *
 * @param buffer
 * @returns
 */
function parse(buffer) {
    const fileAsString = buffer.toString("utf8");
    const translationRowRegex = /"(?<key>.+)"\s+=\s+"(?<value>.+)";\n?/;
    const commentRowRegex = /\/\*\s*(.+)\s*\*\//;
    let translations = [];
    let comments = [];
    let blockStartPoint = 0;
    let blockEndPoint = 0;
    do {
        if (
        /** New Line, new life */
        /\n/.test(fileAsString[blockEndPoint]) ||
            /** EOF  */
            blockEndPoint === fileAsString.length) {
            let match;
            const section = fileAsString.substring(blockStartPoint, blockEndPoint + 1);
            if ((match = section.match(translationRowRegex)) && match.groups) {
                const { groups: { key, value }, } = match;
                translations.push([key, value]);
            }
            else if ((match = section.match(commentRowRegex))) {
                const [, content] = match;
                comments.push(content.trimEnd());
            }
            /** Skipping \n and going to the next block. */
            blockEndPoint += 2;
            blockStartPoint = blockEndPoint - 1;
        }
        else {
            blockEndPoint += 1;
        }
    } while (blockEndPoint <= fileAsString.length);
    return {
        translations,
        comments,
    };
}
/**
 * Creates a strings file buffer
 *
 * @param translations
 * @returns
 */
function create(translations) {
    const stringContents = [];
    const translationsEntries = Object.entries(translations);
    for (let i = 0; i < translationsEntries.length; i++) {
        const [key, value] = translationsEntries[i];
        stringContents.push(`"${key}" = "${value}";`);
    }
    return node_buffer_1.Buffer.from(stringContents.join(node_os_1.EOL));
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU3RyaW5nc1V0aWxzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL1N0cmluZ3NVdGlscy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQWVBLHNCQWlEQztBQVNELHdCQVlDO0FBckZELHFDQUE4QjtBQUM5Qiw2Q0FBcUM7QUFFckMsMENBQTBDO0FBQzFDLDBDQUEwQztBQUMxQywwQ0FBMEM7QUFFMUM7Ozs7OztHQU1HO0FBRUgsU0FBZ0IsS0FBSyxDQUFDLE1BQWM7SUFDbkMsTUFBTSxZQUFZLEdBQUcsTUFBTSxDQUFDLFFBQVEsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUM3QyxNQUFNLG1CQUFtQixHQUFHLHVDQUF1QyxDQUFDO0lBQ3BFLE1BQU0sZUFBZSxHQUFHLG9CQUFvQixDQUFDO0lBRTdDLElBQUksWUFBWSxHQUEyQyxFQUFFLENBQUM7SUFDOUQsSUFBSSxRQUFRLEdBQWEsRUFBRSxDQUFDO0lBRTVCLElBQUksZUFBZSxHQUFHLENBQUMsQ0FBQztJQUN4QixJQUFJLGFBQWEsR0FBRyxDQUFDLENBQUM7SUFFdEIsR0FBRyxDQUFDO1FBQ0g7UUFDQyx5QkFBeUI7UUFDekIsSUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLENBQUM7WUFDdEMsV0FBVztZQUNYLGFBQWEsS0FBSyxZQUFZLENBQUMsTUFBTSxFQUNwQyxDQUFDO1lBQ0YsSUFBSSxLQUE4QixDQUFDO1lBRW5DLE1BQU0sT0FBTyxHQUFHLFlBQVksQ0FBQyxTQUFTLENBQ3JDLGVBQWUsRUFDZixhQUFhLEdBQUcsQ0FBQyxDQUNqQixDQUFDO1lBRUYsSUFBSSxDQUFDLEtBQUssR0FBRyxPQUFPLENBQUMsS0FBSyxDQUFDLG1CQUFtQixDQUFDLENBQUMsSUFBSSxLQUFLLENBQUMsTUFBTSxFQUFFLENBQUM7Z0JBQ2xFLE1BQU0sRUFDTCxNQUFNLEVBQUUsRUFBRSxHQUFHLEVBQUUsS0FBSyxFQUFFLEdBQ3RCLEdBQUcsS0FBSyxDQUFDO2dCQUVWLFlBQVksQ0FBQyxJQUFJLENBQUMsQ0FBQyxHQUFHLEVBQUUsS0FBSyxDQUFDLENBQUMsQ0FBQztZQUNqQyxDQUFDO2lCQUFNLElBQUksQ0FBQyxLQUFLLEdBQUcsT0FBTyxDQUFDLEtBQUssQ0FBQyxlQUFlLENBQUMsQ0FBQyxFQUFFLENBQUM7Z0JBQ3JELE1BQU0sQ0FBQyxFQUFFLE9BQU8sQ0FBQyxHQUFHLEtBQUssQ0FBQztnQkFFMUIsUUFBUSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxFQUFFLENBQUMsQ0FBQztZQUNsQyxDQUFDO1lBRUQsK0NBQStDO1lBQy9DLGFBQWEsSUFBSSxDQUFDLENBQUM7WUFDbkIsZUFBZSxHQUFHLGFBQWEsR0FBRyxDQUFDLENBQUM7UUFDckMsQ0FBQzthQUFNLENBQUM7WUFDUCxhQUFhLElBQUksQ0FBQyxDQUFDO1FBQ3BCLENBQUM7SUFDRixDQUFDLFFBQVEsYUFBYSxJQUFJLFlBQVksQ0FBQyxNQUFNLEVBQUU7SUFFL0MsT0FBTztRQUNOLFlBQVk7UUFDWixRQUFRO0tBQ1IsQ0FBQztBQUNILENBQUM7QUFFRDs7Ozs7R0FLRztBQUVILFNBQWdCLE1BQU0sQ0FBQyxZQUF1QztJQUM3RCxNQUFNLGNBQWMsR0FBRyxFQUFFLENBQUM7SUFFMUIsTUFBTSxtQkFBbUIsR0FBRyxNQUFNLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQyxDQUFDO0lBRXpELEtBQUssSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsR0FBRyxtQkFBbUIsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQztRQUNyRCxNQUFNLENBQUMsR0FBRyxFQUFFLEtBQUssQ0FBQyxHQUFHLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxDQUFDO1FBRTVDLGNBQWMsQ0FBQyxJQUFJLENBQUMsSUFBSSxHQUFHLFFBQVEsS0FBSyxJQUFJLENBQUMsQ0FBQztJQUMvQyxDQUFDO0lBRUQsT0FBTyxvQkFBTSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLGFBQUcsQ0FBQyxDQUFDLENBQUM7QUFDOUMsQ0FBQyJ9