"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Barcode = void 0;
const tslib_1 = require("tslib");
const joi_1 = tslib_1.__importDefault(require("joi"));
exports.Barcode = joi_1.default.object().keys({
    altText: joi_1.default.string(),
    messageEncoding: joi_1.default.string().default("iso-8859-1"),
    format: joi_1.default.string()
        .required()
        .regex(/(PKBarcodeFormatQR|PKBarcodeFormatPDF417|PKBarcodeFormatAztec|PKBarcodeFormatCode128)/, "barcodeType"),
    message: joi_1.default.string().required(),
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQmFyY29kZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9zY2hlbWFzL0JhcmNvZGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7OztBQUFBLHNEQUFzQjtBQW1CVCxRQUFBLE9BQU8sR0FBRyxhQUFHLENBQUMsTUFBTSxFQUFXLENBQUMsSUFBSSxDQUFDO0lBQ2pELE9BQU8sRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBQ3JCLGVBQWUsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQztJQUNuRCxNQUFNLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtTQUNsQixRQUFRLEVBQUU7U0FDVixLQUFLLENBQ0wsdUZBQXVGLEVBQ3ZGLGFBQWEsQ0FDYjtJQUNGLE9BQU8sRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFLENBQUMsUUFBUSxFQUFFO0NBQ2hDLENBQUMsQ0FBQyJ9