"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FieldWithRow = exports.Field = void 0;
const tslib_1 = require("tslib");
const joi_1 = tslib_1.__importDefault(require("joi"));
const Semantics_js_1 = require("./Semantics.js");
exports.Field = joi_1.default.object().keys({
    attributedValue: joi_1.default.alternatives(joi_1.default.string().allow(""), joi_1.default.number(), joi_1.default.date().iso()),
    changeMessage: joi_1.default.string(),
    dataDetectorTypes: joi_1.default.array().items(joi_1.default.string().regex(/(PKDataDetectorTypePhoneNumber|PKDataDetectorTypeLink|PKDataDetectorTypeAddress|PKDataDetectorTypeCalendarEvent)/, "dataDetectorType")),
    label: joi_1.default.string().allow(""),
    textAlignment: joi_1.default.string().regex(/(PKTextAlignmentLeft|PKTextAlignmentCenter|PKTextAlignmentRight|PKTextAlignmentNatural)/, "graphic-alignment"),
    key: joi_1.default.string().required(),
    value: joi_1.default.alternatives(joi_1.default.string().allow(""), joi_1.default.number(), joi_1.default.date().iso()).required(),
    semantics: Semantics_js_1.Semantics,
    // date fields formatters, all optionals
    dateStyle: joi_1.default.string().regex(/(PKDateStyleNone|PKDateStyleShort|PKDateStyleMedium|PKDateStyleLong|PKDateStyleFull)/, "date style"),
    ignoresTimeZone: joi_1.default.boolean(),
    isRelative: joi_1.default.boolean(),
    timeStyle: joi_1.default.string().regex(/(PKDateStyleNone|PKDateStyleShort|PKDateStyleMedium|PKDateStyleLong|PKDateStyleFull)/, "date style"),
    // number fields formatters, all optionals
    currencyCode: joi_1.default.string().when("value", {
        is: joi_1.default.number(),
        otherwise: joi_1.default.string().forbidden(),
    }),
    numberStyle: joi_1.default.string()
        .regex(/(PKNumberStyleDecimal|PKNumberStylePercent|PKNumberStyleScientific|PKNumberStyleSpellOut)/)
        .when("value", {
        is: joi_1.default.number(),
        otherwise: joi_1.default.string().forbidden(),
    }),
});
exports.FieldWithRow = exports.Field.concat(joi_1.default.object().keys({
    row: joi_1.default.number().min(0).max(1),
}));
//# sourceMappingURL=data:application/json;base64,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