"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PassFields = exports.TransitType = void 0;
const tslib_1 = require("tslib");
const joi_1 = tslib_1.__importDefault(require("joi"));
const Field_js_1 = require("./Field.js");
exports.TransitType = joi_1.default.string().regex(/(PKTransitTypeAir|PKTransitTypeBoat|PKTransitTypeBus|PKTransitTypeGeneric|PKTransitTypeTrain)/);
exports.PassFields = joi_1.default.object().keys({
    auxiliaryFields: joi_1.default.array().items(Field_js_1.FieldWithRow),
    backFields: joi_1.default.array().items(Field_js_1.Field),
    headerFields: joi_1.default.array().items(Field_js_1.Field),
    primaryFields: joi_1.default.array().items(Field_js_1.Field),
    secondaryFields: joi_1.default.array().items(Field_js_1.Field),
    transitType: exports.TransitType,
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     * @passDomain dashboard
     *
     * @see \<undiclosed>
     */
    additionalInfoFields: joi_1.default.array().items(Field_js_1.Field),
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiUGFzc0ZpZWxkcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9zY2hlbWFzL1Bhc3NGaWVsZHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7OztBQUFBLHNEQUFzQjtBQUN0Qix5Q0FBaUQ7QUFTcEMsUUFBQSxXQUFXLEdBQUcsYUFBRyxDQUFDLE1BQU0sRUFBRSxDQUFDLEtBQUssQ0FDNUMsK0ZBQStGLENBQy9GLENBQUM7QUFvQlcsUUFBQSxVQUFVLEdBQUcsYUFBRyxDQUFDLE1BQU0sRUFBYyxDQUFDLElBQUksQ0FBQztJQUN2RCxlQUFlLEVBQUUsYUFBRyxDQUFDLEtBQUssRUFBRSxDQUFDLEtBQUssQ0FBQyx1QkFBWSxDQUFDO0lBQ2hELFVBQVUsRUFBRSxhQUFHLENBQUMsS0FBSyxFQUFFLENBQUMsS0FBSyxDQUFDLGdCQUFLLENBQUM7SUFDcEMsWUFBWSxFQUFFLGFBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyxLQUFLLENBQUMsZ0JBQUssQ0FBQztJQUN0QyxhQUFhLEVBQUUsYUFBRyxDQUFDLEtBQUssRUFBRSxDQUFDLEtBQUssQ0FBQyxnQkFBSyxDQUFDO0lBQ3ZDLGVBQWUsRUFBRSxhQUFHLENBQUMsS0FBSyxFQUFFLENBQUMsS0FBSyxDQUFDLGdCQUFLLENBQUM7SUFDekMsV0FBVyxFQUFFLG1CQUFXO0lBRXhCOzs7Ozs7T0FNRztJQUNILG9CQUFvQixFQUFFLGFBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyxLQUFLLENBQUMsZ0JBQUssQ0FBQztDQUM5QyxDQUFDLENBQUMifQ==