import { EOL } from "node:os";
import { Buffer } from "node:buffer";
// ************************************ //
// *** UTILS FOR PASS.STRINGS FILES *** //
// ************************************ //
/**
 * Parses a string file to convert it to
 * an object
 *
 * @param buffer
 * @returns
 */
export function parse(buffer) {
    const fileAsString = buffer.toString("utf8");
    const translationRowRegex = /"(?<key>.+)"\s+=\s+"(?<value>.+)";\n?/;
    const commentRowRegex = /\/\*\s*(.+)\s*\*\//;
    let translations = [];
    let comments = [];
    let blockStartPoint = 0;
    let blockEndPoint = 0;
    do {
        if (
        /** New Line, new life */
        /\n/.test(fileAsString[blockEndPoint]) ||
            /** EOF  */
            blockEndPoint === fileAsString.length) {
            let match;
            const section = fileAsString.substring(blockStartPoint, blockEndPoint + 1);
            if ((match = section.match(translationRowRegex)) && match.groups) {
                const { groups: { key, value }, } = match;
                translations.push([key, value]);
            }
            else if ((match = section.match(commentRowRegex))) {
                const [, content] = match;
                comments.push(content.trimEnd());
            }
            /** Skipping \n and going to the next block. */
            blockEndPoint += 2;
            blockStartPoint = blockEndPoint - 1;
        }
        else {
            blockEndPoint += 1;
        }
    } while (blockEndPoint <= fileAsString.length);
    return {
        translations,
        comments,
    };
}
/**
 * Creates a strings file buffer
 *
 * @param translations
 * @returns
 */
export function create(translations) {
    const stringContents = [];
    const translationsEntries = Object.entries(translations);
    for (let i = 0; i < translationsEntries.length; i++) {
        const [key, value] = translationsEntries[i];
        stringContents.push(`"${key}" = "${value}";`);
    }
    return Buffer.from(stringContents.join(EOL));
}
//# sourceMappingURL=data:application/json;base64,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