export const INIT = {
    INVALID_BUFFERS: "Cannot set buffers in constructor: expected object but received %s",
};
export const CERTIFICATES = {
    INVALID: "Invalid certificate(s) loaded. %s. Please provide valid WWDR certificates and developer signer certificate and key (with passphrase).\nRefer to docs to obtain them",
};
export const TRANSIT_TYPE = {
    UNEXPECTED_PASS_TYPE: "Cannot set transitType on a pass with type different from boardingPass.",
    INVALID: "Cannot set transitType because not compliant with Apple specifications. Refer to https://apple.co/3DHuAG4 for more - %s",
};
export const PREFERRED_STYLE_SCHEMES = {
    UNEXPECTED_PASS_TYPE_SET: "Cannot set preferredStyleSchemes on a pass with type different from eventTicket.",
    UNEXPECTED_PASS_TYPE_GET: "Cannot get preferredStyleSchemes on a pass with type different from eventTicket.",
    INVALID: "Cannot set preferredStyleSchemes because not compliant with Apple specifications - %s",
};
export const PASS_TYPE = {
    INVALID: "Cannot set type because not compliant with Apple specifications. Refer to https://apple.co/3aFpSfg for a list of valid props - %s",
};
export const TEMPLATE = {
    INVALID: "Cannot create pass from a template. %s",
};
export const FILTER_VALID = {
    INVALID: "Cannot validate property. %s",
};
export const FIELDS = {
    INVALID: "Cannot add field. %s",
    REPEATED_KEY: "Cannot add field with key '%s': another field already owns this key. Ignored.",
};
export const RELEVANT_DATE = {
    INVALID: "Cannot set relevant date. Date format is invalid",
};
export const DATE = {
    INVALID: "Cannot set %s. Invalid date %s",
};
export const LANGUAGES = {
    INVALID_LANG: "Cannot set localization. Expected a string for 'lang' but received %s",
    NO_TRANSLATIONS: "Cannot create or use language %s. If your itention was to just add a language (.lproj) folder to the bundle, both specify some translations or use .addBuffer to add some media.",
};
export const BARCODES = {
    INVALID_POST: "",
};
export const PASS_SOURCE = {
    INVALID: "Cannot add pass.json to bundle because it is invalid. %s",
    UNKNOWN_TYPE: "Cannot find a valid type in pass.json. You won't be able to set fields until you won't set explicitly one.",
    JOIN: "The imported pass.json's properties will be joined with the current setted props. You might lose some data.",
};
export const PERSONALIZE = {
    INVALID: "Cannot add personalization.json to bundle because it is invalid. %s",
};
export const JSON = {
    INVALID: "Cannot parse JSON. Invalid file",
};
export const CLOSE = {
    MISSING_TYPE: "Cannot proceed creating the pass because type is missing.",
    MISSING_ICON: "At least one icon file is missing in your bundle. Your pass won't be openable by any Apple Device.",
    PERSONALIZATION_REMOVED: "Personalization file '%s' have been removed from the bundle as the requirements for personalization are not met.",
    MISSING_TRANSIT_TYPE: "Cannot proceed creating the pass because transitType is missing on your boardingPass.",
};
export const MODELS = {
    DIR_NOT_FOUND: "Cannot import model: directory %s not found.",
    FILE_NO_OPEN: "Cannot open model file. %s",
};
export const BUNDLE = {
    MIME_TYPE_MISSING: "Cannot build Bundle. MimeType is missing",
    CLOSED: "Cannot add file or set property. Bundle is closed.",
};
export const FROM = {
    MISSING_SOURCE: "Cannot create PKPass from source: source is '%s'",
};
export const PACK = {
    INVALID: "Cannot pack passes. Only PKPass instances allowed",
};
/**
 * Creates a message with replaced values
 * @param messageName
 * @param values
 */
export function format(messageName, ...values) {
    // reversing because it is better popping than shifting.
    const replaceValues = values.reverse();
    return messageName.replace(/%s/g, () => replaceValues.pop());
}
//# sourceMappingURL=data:application/json;base64,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