import { Buffer } from "node:buffer";
import Joi from "joi";
/**
 * Joi.binary is not available in browser-like environments (like Cloudflare workers)
 * so we fallback to manual checking. Buffer must be polyfilled.
 */
const binary = Joi.binary
    ? Joi.binary()
    : Joi.custom((obj) => Buffer.isBuffer(obj));
export const CertificatesSchema = Joi.object()
    .keys({
    wwdr: Joi.alternatives(binary, Joi.string()).required(),
    signerCert: Joi.alternatives(binary, Joi.string()).required(),
    signerKey: Joi.alternatives(binary, Joi.string()).required(),
    signerKeyPassphrase: Joi.string(),
})
    .required();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQ2VydGlmaWNhdGVzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3NjaGVtYXMvQ2VydGlmaWNhdGVzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxNQUFNLEVBQUUsTUFBTSxhQUFhLENBQUM7QUFDckMsT0FBTyxHQUFHLE1BQU0sS0FBSyxDQUFDO0FBU3RCOzs7R0FHRztBQUVILE1BQU0sTUFBTSxHQUFHLEdBQUcsQ0FBQyxNQUFNO0lBQ3hCLENBQUMsQ0FBQyxHQUFHLENBQUMsTUFBTSxFQUFFO0lBQ2QsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQUMsQ0FBQyxHQUFHLEVBQUUsRUFBRSxDQUFDLE1BQU0sQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztBQUU3QyxNQUFNLENBQUMsTUFBTSxrQkFBa0IsR0FBRyxHQUFHLENBQUMsTUFBTSxFQUFzQjtLQUNoRSxJQUFJLENBQUM7SUFDTCxJQUFJLEVBQUUsR0FBRyxDQUFDLFlBQVksQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLE1BQU0sRUFBRSxDQUFDLENBQUMsUUFBUSxFQUFFO0lBQ3ZELFVBQVUsRUFBRSxHQUFHLENBQUMsWUFBWSxDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsTUFBTSxFQUFFLENBQUMsQ0FBQyxRQUFRLEVBQUU7SUFDN0QsU0FBUyxFQUFFLEdBQUcsQ0FBQyxZQUFZLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxDQUFDLFFBQVEsRUFBRTtJQUM1RCxtQkFBbUIsRUFBRSxHQUFHLENBQUMsTUFBTSxFQUFFO0NBQ2pDLENBQUM7S0FDRCxRQUFRLEVBQUUsQ0FBQyJ9