import Joi from "joi";
import { Semantics } from "./Semantics.js";
export const Field = Joi.object().keys({
    attributedValue: Joi.alternatives(Joi.string().allow(""), Joi.number(), Joi.date().iso()),
    changeMessage: Joi.string(),
    dataDetectorTypes: Joi.array().items(Joi.string().regex(/(PKDataDetectorTypePhoneNumber|PKDataDetectorTypeLink|PKDataDetectorTypeAddress|PKDataDetectorTypeCalendarEvent)/, "dataDetectorType")),
    label: Joi.string().allow(""),
    textAlignment: Joi.string().regex(/(PKTextAlignmentLeft|PKTextAlignmentCenter|PKTextAlignmentRight|PKTextAlignmentNatural)/, "graphic-alignment"),
    key: Joi.string().required(),
    value: Joi.alternatives(Joi.string().allow(""), Joi.number(), Joi.date().iso()).required(),
    semantics: Semantics,
    // date fields formatters, all optionals
    dateStyle: Joi.string().regex(/(PKDateStyleNone|PKDateStyleShort|PKDateStyleMedium|PKDateStyleLong|PKDateStyleFull)/, "date style"),
    ignoresTimeZone: Joi.boolean(),
    isRelative: Joi.boolean(),
    timeStyle: Joi.string().regex(/(PKDateStyleNone|PKDateStyleShort|PKDateStyleMedium|PKDateStyleLong|PKDateStyleFull)/, "date style"),
    // number fields formatters, all optionals
    currencyCode: Joi.string().when("value", {
        is: Joi.number(),
        otherwise: Joi.string().forbidden(),
    }),
    numberStyle: Joi.string()
        .regex(/(PKNumberStyleDecimal|PKNumberStylePercent|PKNumberStyleScientific|PKNumberStyleSpellOut)/)
        .when("value", {
        is: Joi.number(),
        otherwise: Joi.string().forbidden(),
    }),
});
export const FieldWithRow = Field.concat(Joi.object().keys({
    row: Joi.number().min(0).max(1),
}));
//# sourceMappingURL=data:application/json;base64,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