import Joi from "joi";
import * as SemanticTagType from "./SemanticTagType.js";
export const Semantics = Joi.object().keys({
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    admissionLevel: Joi.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    admissionLevelAbbreviation: Joi.string(),
    airlineCode: Joi.string(),
    artistIDs: Joi.array().items(Joi.string()),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    albumIDs: Joi.array().items(Joi.string()),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    airplay: Joi.array().items({
        airplayDeviceGroupToken: Joi.string(),
    }),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    attendeeName: Joi.string(),
    awayTeamAbbreviation: Joi.string(),
    awayTeamLocation: Joi.string(),
    awayTeamName: Joi.string(),
    additionalTicketAttributes: Joi.string(),
    balance: SemanticTagType.CurrencyAmount,
    boardingGroup: Joi.string(),
    boardingSequenceNumber: Joi.string(),
    carNumber: Joi.string(),
    confirmationNumber: Joi.string(),
    currentArrivalDate: Joi.string(),
    currentBoardingDate: Joi.string(),
    currentDepartureDate: Joi.string(),
    departureAirportCode: Joi.string(),
    departureAirportName: Joi.string(),
    departureGate: Joi.string(),
    departureLocation: SemanticTagType.Location,
    departureLocationDescription: Joi.string(),
    departurePlatform: Joi.string(),
    departureStationName: Joi.string(),
    departureTerminal: Joi.string(),
    destinationAirportCode: Joi.string(),
    destinationAirportName: Joi.string(),
    destinationGate: Joi.string(),
    destinationLocation: SemanticTagType.Location,
    destinationLocationDescription: Joi.string(),
    destinationPlatform: Joi.string(),
    destinationStationName: Joi.string(),
    destinationTerminal: Joi.string(),
    duration: Joi.number(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    entranceDescription: Joi.string(),
    eventEndDate: Joi.string(),
    eventName: Joi.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     *
     * Shows a message in the live activity
     * when the activity starts.
     */
    eventLiveMessage: Joi.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout).
     *
     * Can be used as an alternative way to
     * show show start date, with more control
     * on time and timeZone details and as
     * a way to show the event guide, both
     * instead of `eventStartDate`.
     */
    eventStartDateInfo: SemanticTagType.EventDateInfo,
    eventStartDate: Joi.string(),
    eventType: Joi.string().regex(/(PKEventTypeGeneric|PKEventTypeLivePerformance|PKEventTypeMovie|PKEventTypeSports|PKEventTypeConference|PKEventTypeConvention|PKEventTypeWorkshop|PKEventTypeSocialGathering)/),
    flightCode: Joi.string(),
    flightNumber: Joi.number(),
    genre: Joi.string(),
    homeTeamAbbreviation: Joi.string(),
    homeTeamLocation: Joi.string(),
    homeTeamName: Joi.string(),
    leagueAbbreviation: Joi.string(),
    leagueName: Joi.string(),
    membershipProgramName: Joi.string(),
    membershipProgramNumber: Joi.string(),
    originalArrivalDate: Joi.string(),
    originalBoardingDate: Joi.string(),
    originalDepartureDate: Joi.string(),
    passengerName: SemanticTagType.PersonNameComponents,
    performerNames: Joi.array().items(Joi.string()),
    priorityStatus: Joi.string(),
    playlistIDs: Joi.array().items(Joi.string()),
    seats: Joi.array().items(SemanticTagType.Seat),
    securityScreening: Joi.string(),
    silenceRequested: Joi.boolean(),
    sportName: Joi.string(),
    tailgatingAllowed: Joi.boolean(),
    totalPrice: SemanticTagType.CurrencyAmount,
    transitProvider: Joi.string(),
    transitStatus: Joi.string(),
    transitStatusReason: Joi.string(),
    vehicleName: Joi.string(),
    vehicleNumber: Joi.string(),
    vehicleType: Joi.string(),
    venueEntrance: Joi.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueGatesOpenDate: Joi.string(),
    venueLocation: SemanticTagType.Location,
    venueName: Joi.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueParkingLotsOpenDate: Joi.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueBoxOfficeOpenDate: Joi.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueDoorsOpenDate: Joi.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueFanZoneOpenDate: Joi.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueOpenDate: Joi.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueCloseDate: Joi.string(),
    venuePhoneNumber: Joi.string(),
    venueRoom: Joi.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueRegionName: Joi.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueEntranceGate: Joi.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueEntranceDoor: Joi.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueEntrancePortal: Joi.string(),
    wifiAccess: Joi.array().items(SemanticTagType.WifiNetwork),
});
//# sourceMappingURL=data:application/json;base64,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