import Joi from "joi";
/**
 * These couple of structures are organized alphabetically,
 * according to the order on the developer documentation.
 *
 * @see https://developer.apple.com/documentation/walletpasses/semantictagtype
 */
/**
 * @see https://developer.apple.com/documentation/walletpasses/semantictagtype/currencyamount-data.dictionary
 */
export interface CurrencyAmount {
    currencyCode?: string;
    amount?: string;
}
export declare const CurrencyAmount: Joi.ObjectSchema<CurrencyAmount>;
/**
 * @iOSVersion 18
 * @passStyle eventTicket (new layout)
 *
 * @see \<undiclosed>
 */
export interface EventDateInfo {
    date: string;
    ignoreTimeComponents?: boolean;
    timeZone?: string;
}
export declare const EventDateInfo: Joi.ObjectSchema<EventDateInfo>;
/**
 * @see https://developer.apple.com/documentation/walletpasses/semantictagtype/location-data.dictionary
 */
export interface Location {
    latitude: number;
    longitude: number;
}
export declare const Location: Joi.ObjectSchema<Location>;
/**
 * @see https://developer.apple.com/documentation/walletpasses/semantictagtype/personnamecomponents-data.dictionary
 */
export interface PersonNameComponents {
    familyName?: string;
    givenName?: string;
    middleName?: string;
    namePrefix?: string;
    nameSuffix?: string;
    nickname?: string;
    phoneticRepresentation?: string;
}
export declare const PersonNameComponents: Joi.ObjectSchema<PersonNameComponents>;
/**
 * @see https://developer.apple.com/documentation/walletpasses/semantictagtype/seat-data.dictionary
 */
export interface Seat {
    seatSection?: string;
    seatRow?: string;
    seatNumber?: string;
    seatIdentifier?: string;
    seatType?: string;
    seatDescription?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    seatAisle?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    seatLevel?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    seatSectionColor?: string;
}
export declare const Seat: Joi.ObjectSchema<Seat>;
/**
 * @see https://developer.apple.com/documentation/walletpasses/semantictagtype/wifinetwork-data.dictionary
 */
export interface WifiNetwork {
    password: string;
    ssid: string;
}
export declare const WifiNetwork: Joi.ObjectSchema<WifiNetwork>;
