import Joi from "joi";
import * as SemanticTagType from "./SemanticTagType.js";
/**
 * For a better description of every single field,
 * please refer to Apple official documentation.
 *
 * @see https://developer.apple.com/documentation/walletpasses/semantictags
 */
/**
 * Alphabetical order
 * @see https://developer.apple.com/documentation/walletpasses/semantictags
 */
export interface Semantics {
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    admissionLevel?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    admissionLevelAbbreviation?: string;
    airlineCode?: string;
    artistIDs?: string[];
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    albumIDs?: string[];
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    airplay?: {
        airPlayDeviceGroupToken: string;
    }[];
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    attendeeName?: string;
    awayTeamAbbreviation?: string;
    awayTeamLocation?: string;
    awayTeamName?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    additionalTicketAttributes?: string;
    balance?: SemanticTagType.CurrencyAmount;
    boardingGroup?: string;
    boardingSequenceNumber?: string;
    carNumber?: string;
    confirmationNumber?: string;
    currentArrivalDate?: string;
    currentBoardingDate?: string;
    currentDepartureDate?: string;
    departureAirportCode?: string;
    departureAirportName?: string;
    departureGate?: string;
    departureLocation?: SemanticTagType.Location;
    departureLocationDescription?: string;
    departurePlatform?: string;
    departureStationName?: string;
    departureTerminal?: string;
    destinationAirportCode?: string;
    destinationAirportName?: string;
    destinationGate?: string;
    destinationLocation?: SemanticTagType.Location;
    destinationLocationDescription?: string;
    destinationPlatform?: string;
    destinationStationName?: string;
    destinationTerminal?: string;
    duration?: number;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    entranceDescription?: string;
    eventEndDate?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     *
     * Shows a message in the live activity
     * when the activity starts.
     */
    eventLiveMessage?: string;
    eventName?: string;
    eventStartDate?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout).
     *
     * Can be used as an alternative way to
     * show show start date, with more control
     * on time and timeZone details and as
     * a way to show the event guide, both
     * instead of `eventStartDate`.
     */
    eventStartDateInfo?: SemanticTagType.EventDateInfo;
    /**
     * @iOSVersion < 18
     * Since iOS 18, for the event tickets these determine
     * the template to be used when rendering the pass.
     *
     * - Generic Template
     * 		- "PKEventTypeGeneric"
     * 		- "PKEventTypeMovie"
     * 		- "PKEventTypeConference"
     * 		- "PKEventTypeConvention"
     * 		- "PKEventTypeWorkshop"
     * 		- "PKEventTypeSocialGathering"
     * - Sport Template
     * 		- "PKEventTypeSports"
     * - Live Performance Template
     * 		- "PKEventTypeLivePerformance";
     */
    eventType?: "PKEventTypeGeneric" | "PKEventTypeMovie" | "PKEventTypeConference" | "PKEventTypeConvention" | "PKEventTypeWorkshop" | "PKEventTypeSocialGathering" | "PKEventTypeSports" | "PKEventTypeLivePerformance";
    flightCode?: string;
    flightNumber?: number;
    genre?: string;
    homeTeamAbbreviation?: string;
    homeTeamLocation?: string;
    homeTeamName?: string;
    leagueAbbreviation?: string;
    leagueName?: string;
    membershipProgramName?: string;
    membershipProgramNumber?: string;
    originalArrivalDate?: string;
    originalBoardingDate?: string;
    originalDepartureDate?: string;
    passengerName?: SemanticTagType.PersonNameComponents;
    performerNames?: string[];
    priorityStatus?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    playlistIDs?: string[];
    seats?: SemanticTagType.Seat[];
    securityScreening?: string;
    silenceRequested?: boolean;
    sportName?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    tailgatingAllowed?: boolean;
    totalPrice?: SemanticTagType.CurrencyAmount;
    transitProvider?: string;
    transitStatus?: string;
    transitStatusReason?: string;
    vehicleName?: string;
    vehicleNumber?: string;
    vehicleType?: string;
    venueEntrance?: string;
    venueLocation?: SemanticTagType.Location;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueGatesOpenDate?: string;
    venueName?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueParkingLotsOpenDate?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueBoxOfficeOpenDate?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueDoorsOpenDate?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueFanZoneOpenDate?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueOpenDate?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueCloseDate?: string;
    venuePhoneNumber?: string;
    venueRoom?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueRegionName?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueEntranceGate?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueEntranceDoor?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueEntrancePortal?: string;
    wifiAccess?: SemanticTagType.WifiNetwork[];
}
export declare const Semantics: Joi.ObjectSchema<Semantics>;
